<?php
/*
# mod_itcs_teamcard - CSS3 based Module by it-conserv.de
# ------------------------------------------------------------------------
# Author    it-conserv.de
# Copyright (C) 2016 it-conserv.de All Rights Reserved.
# License - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# CSS Style is a free resource from http://littlesnippets.net/ 
# Websites: it-conserv.de
# ------------------------------------------------------------------------
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

$baseurl 		= JURI::base();
$teamcards = $params->get('teamcards');

// Load basic define settings
$tc_css='
.id'.$uniqid.' figure.snip0099 figcaption h2,
.id'.$uniqid.'  figure.snip0099 figcaption p{
	color: '.$text_color.';
}
.id'.$uniqid.' figure.snip0099 figcaption h2 {
  border-bottom: 1px solid '.$text_color.';
}
.id'.$uniqid.' figure.snip0099 figcaption {
    background-color: '.$back_color.';
}
.id'.$uniqid.' figure.snip0099:after{
	background-color: '.$mid_color.';
}
';

// Put styling in header
$document->addStyleDeclaration($tc_css);

?>
<div class="teamcard <?php echo 'id'.$uniqid.' '.$tc_align ?>">
<?php
    foreach ($teamcards as $item) {
		if (!empty($item->tc_image)) {
			
			//image format and name
			$img_name	= str_replace('https://', 'http://', $item->tc_image);
			$size 		= getimagesize( $img_name);  
			$img_form	= $size[0] > $size[1]?"ls":"pr";	// pr -> portrait, ls -> landscape
			$img_alt	= basename($img_name);
			
			echo '<div class="tc_main">';
			echo '<figure class="snip0099 '.($item->img_align).'">';
			echo '<img class="'.$img_form.'" src="'.($item->tc_image).'" alt="'.$img_alt.'"/>';
			echo '<div class="icons">';
			if ($show_1 == 1 && !empty($icon_1) && !empty($item->link_1)) {
				echo '<a href="'.$item->link_1.'"><i class="'.$icon_1.'"></i></a>';
			}
			if ($show_2 == 1 && !empty($icon_2) && !empty($item->link_2)) {
				echo '<a href="'.$item->link_2.'"><i class="'.$icon_2.'"></i></a>';
			}
			if ($show_3 == 1 && !empty($icon_3) && !empty($item->link_3)) {
				echo '<a href="'.$item->link_3.'"><i class="'.$icon_3.'"></i></a>';
			}
			echo '</div><figcaption>';
			echo '<h2>'.$item->h2_1.' <span>'.$item->h2_2.'</span></h2>';
			echo '<p>'.$item->text.'</p>';
			echo '</figcaption></figure>';
			echo '</div>';
		}
	}
?>
</div>