<?php
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import Joomla view library
jimport('joomla.application.component.view');
jimport('connectdaily.class-cdaily-external-link');
/**
 * ConnectDaily Events Calendar Content Plugin
 *  
 * @package Joomla.Component
 * @subpackage Content.connectdaily 
 * @copyright (C) 2016 - MH Software, Inc. 
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
 * @author gsexton (3/11/16) 
 */
class ConnectDailyViewConnectDaily extends JViewLegacy {

    public $settings;
    public $plugin;
    public $is_configured;
    private $isSupportedPHP;

    /**
     * connectDaily view display method
     * @return void
     */
    function display($tpl = null) {
        
        $this->settings = $this->get('Settings');
        $this->is_configured=!empty($this->settings->url);
        $this->plugin = $this->get('Plugin');
        $this->isSupportedPHP=$this->plugin->phpVersionCheck();
        $notices=$this->plugin->getNotices();
        $aMessages=$notices->getMessages();
        $count = $notices->getMessageCount();
        if (empty($count)) {
            $aOverview=$this->plugin->getUnseenHints(array('AddEvents','SolicitReview'));
            $count=sizeof($aOverview);
            if ($count>0) {
                $search=array("{tutorial_url}","{library_path}","{support_page}");
                $replace=array(CDailyJoomlaPlugin::TUTORIAL_URL,
                               $this->plugin->getSiteUrl().'libraries/connectdaily/',
                               "index.php?task=support.showsupport&option=com_connectdaily"
                               );
                $msg=str_replace($search,$replace,JText::_('COM_CONNECTDAILY_HINT_'.strtoupper($aOverview[0]),false,false));
                
                $dismiss=sprintf(JText::_('COM_CONNECTDAILY_DISMISSHINT',false,false),$aOverview[0]);

                JFactory::getApplication()->enqueueMessage(
                    $msg.
                    $dismiss
                    );
            }
        } else {
            foreach ($aMessages as $msg) {
                JFactory::getApplication()->enqueueMessage($msg,'error');
            }
        }

        $this->ajaxURL = $this->plugin->getSiteUrl() . 'administrator/index.php?option=com_connectdaily&task=doSSOAjax&format=raw';

        // Set the toolbar
        $this->addToolBar();
        // Display the template
        parent::display($tpl);

        // Set the document
        $this->setDocument();
    }

    /**
     * Setting the toolbar
     */
    protected function addToolBar() {
        JToolBarHelper::title(JText::_('COM_CONNECTDAILY_COMPONENT'), 'connectdaily');

        $tb = JToolBar::getInstance();

        if (!empty($this->settings->url) && $this->isSupportedPHP) {
            $tb->appendButton('ExternalLink', 'enter', JText::_('COM_CONNECTDAILY_LOGIN'), 'return CDaily.doSingleSignon();');
        }
        JToolBarHelper::custom('tutorials.showtutorial', 'video', 'video', JText::_('COM_CONNECTDAILY_TUTORIALS'), false);
        JToolBarHelper::custom('support.showsupport', 'phone-2', 'phone-2', JText::_('COM_CONNECTDAILY_SUPPORT'), false);
        
        $tb->appendButton('ExternalLink', 'help', JText::_('JTOOLBAR_HELP'), 'http://livedemo.mhsoftware.com/manual/en/pageFinder.html?page=JoomlaCalendarPlugin.html');
        if ($this->isSupportedPHP) {
            JToolBarHelper::custom('settings.showsettings', 'options', 'options', JText::_('JOPTIONS'), false);
        }
    }
    /**
     * Method to set up the document properties
     *
     * @return void
     */
    protected function setDocument() {
        $document = JFactory::getDocument();
        $document->setTitle(JText::_('COM_CONNECTDAILY_COMPONENT'));
    }
}
